/*
 * Decompiled with CFR 0.152.
 */
package izone.calendar;

import java.util.Calendar;
import java.util.Date;

public class DateUtil {
    protected Date minSelectableDate;
    protected Date maxSelectableDate;
    protected Date defaultMinSelectableDate;
    protected Date defaultMaxSelectableDate;

    public DateUtil() {
        Calendar tmpCalendar = Calendar.getInstance();
        tmpCalendar.set(1, 0, 1, 1, 1);
        this.minSelectableDate = this.defaultMinSelectableDate = tmpCalendar.getTime();
        tmpCalendar.set(9999, 0, 1, 1, 1);
        this.maxSelectableDate = this.defaultMaxSelectableDate = tmpCalendar.getTime();
    }

    public void setSelectableDateRange(Date min, Date max) {
        this.minSelectableDate = min == null ? this.defaultMinSelectableDate : min;
        this.maxSelectableDate = max == null ? this.defaultMaxSelectableDate : max;
        if (this.maxSelectableDate.before(this.minSelectableDate)) {
            this.minSelectableDate = this.defaultMinSelectableDate;
            this.maxSelectableDate = this.defaultMaxSelectableDate;
        }
    }

    public Date setMaxSelectableDate(Date max) {
        this.maxSelectableDate = max == null ? this.defaultMaxSelectableDate : max;
        return this.maxSelectableDate;
    }

    public Date setMinSelectableDate(Date min) {
        this.minSelectableDate = min == null ? this.defaultMinSelectableDate : min;
        return this.minSelectableDate;
    }

    public Date getMaxSelectableDate() {
        return this.maxSelectableDate;
    }

    public Date getMinSelectableDate() {
        return this.minSelectableDate;
    }

    public boolean checkDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Calendar minCal = Calendar.getInstance();
        minCal.setTime(this.minSelectableDate);
        minCal.set(11, 0);
        minCal.set(12, 0);
        minCal.set(13, 0);
        minCal.set(14, 0);
        Calendar maxCal = Calendar.getInstance();
        maxCal.setTime(this.maxSelectableDate);
        maxCal.set(11, 0);
        maxCal.set(12, 0);
        maxCal.set(13, 0);
        maxCal.set(14, 0);
        return !calendar.before(minCal) && !calendar.after(maxCal);
    }
}

