/*
 * Decompiled with CFR 0.152.
 */
package izone.calendar.demo;

import com.jgoodies.looks.FontPolicies;
import com.jgoodies.looks.FontPolicy;
import com.jgoodies.looks.FontSet;
import com.jgoodies.looks.FontSets;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.toedter.calendar.demo.DateChooserPanel;
import izone.calendar.JCalendar;
import izone.calendar.JDateChooser;
import izone.calendar.JDayChooser;
import izone.calendar.JMonthChooser;
import izone.calendar.JYearChooser;
import izone.components.JLocaleChooser;
import izone.components.JSpinField;
import izone.components.JTitlePanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public class JCalendarDemo
extends JApplet
implements PropertyChangeListener {
    private static final long serialVersionUID = 6739986412544494316L;
    private JSplitPane splitPane;
    private JPanel calendarPanel;
    private JComponent[] beans;
    private JPanel propertyPanel;
    private JTitlePanel propertyTitlePanel;
    private JTitlePanel componentTitlePanel;
    private JPanel componentPanel;
    private JToolBar toolBar;

    public void init() {
        this.initializeLookAndFeels();
        this.beans = new JComponent[6];
        this.beans[1] = new JCalendar();
        this.beans[2] = new JDayChooser();
        this.beans[3] = new JMonthChooser();
        this.beans[4] = new JYearChooser();
        this.beans[5] = new JSpinField();
        ((JSpinField)this.beans[5]).adjustWidthToMaximumValue();
        ((JYearChooser)this.beans[4]).setMaximum(((JSpinField)this.beans[5]).getMaximum());
        ((JYearChooser)this.beans[4]).adjustWidthToMaximumValue();
        this.getContentPane().setLayout(new BorderLayout());
        this.setJMenuBar(this.createMenuBar());
        this.toolBar = this.createToolBar();
        this.getContentPane().add((Component)this.toolBar, "North");
        this.splitPane = new JSplitPane(0);
        this.splitPane.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        this.splitPane.setDividerSize(4);
        this.splitPane.setDividerLocation(240);
        BasicSplitPaneDivider divider = ((BasicSplitPaneUI)this.splitPane.getUI()).getDivider();
        if (divider != null) {
            divider.setBorder(null);
        }
        this.propertyPanel = new JPanel();
        URL iconURL = this.beans[0].getClass().getResource("images/" + this.beans[0].getName() + "Color16.gif");
        ImageIcon icon = new ImageIcon(iconURL);
        this.propertyTitlePanel = new JTitlePanel("Properties", null, this.propertyPanel, BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.splitPane.setBottomComponent(this.propertyTitlePanel);
        this.installBean(this.beans[0]);
        this.getContentPane().add((Component)this.splitPane, "Center");
        this.componentTitlePanel = new JTitlePanel("Component", icon, this.componentPanel, BorderFactory.createEmptyBorder(4, 4, 0, 4));
        this.getContentPane().add((Component)this.componentTitlePanel, "Center");
        this.componentPanel = new JPanel();
        this.beans[0] = new DateChooserPanel();
        this.componentPanel.add(this.beans[0]);
    }

    public final void initializeLookAndFeels() {
        try {
            UIManager.LookAndFeelInfo[] lnfs = UIManager.getInstalledLookAndFeels();
            boolean found = false;
            for (int i = 0; i < lnfs.length; ++i) {
                if (!lnfs[i].getName().equals("JGoodies Plastic 3D")) continue;
                found = true;
            }
            if (!found) {
                UIManager.installLookAndFeel("JGoodies Plastic 3D", "com.jgoodies.looks.plastic.Plastic3DLookAndFeel");
            }
            String os = System.getProperty("os.name");
            FontSet fontSet = null;
            fontSet = os.startsWith("Windows") ? FontSets.createDefaultFontSet((Font)new Font("arial unicode MS", 0, 12)) : FontSets.createDefaultFontSet((Font)new Font("arial unicode", 0, 12));
            FontPolicy fixedPolicy = FontPolicies.createFixedPolicy((FontSet)fontSet);
            PlasticLookAndFeel.setFontPolicy((FontPolicy)fixedPolicy);
            UIManager.setLookAndFeel("com.jgoodies.looks.plastic.Plastic3DLookAndFeel");
        }
        catch (Throwable t) {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public JToolBar createToolBar() {
        this.toolBar = new JToolBar();
        this.toolBar.putClientProperty("jgoodies.headerStyle", "Both");
        this.toolBar.setRollover(true);
        this.toolBar.setFloatable(false);
        for (int i = 0; i < this.beans.length; ++i) {
            JButton button;
            try {
                JComponent bean = this.beans[i];
                URL iconURL = bean.getClass().getResource("images/" + bean.getName() + "Color16.gif");
                ImageIcon icon = new ImageIcon(iconURL);
                button = new JButton(icon);
                ActionListener actionListener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        JCalendarDemo.this.installBean(bean);
                    }
                };
                button.addActionListener(actionListener);
            }
            catch (Exception e) {
                System.out.println("JCalendarDemo.createToolBar(): " + e);
                button = new JButton(this.beans[i].getName());
            }
            button.setFocusPainted(false);
            this.toolBar.add(button);
        }
        return this.toolBar;
    }

    public JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu componentsMenu = new JMenu("Components");
        componentsMenu.setMnemonic('C');
        menuBar.add(componentsMenu);
        for (int i = 0; i < this.beans.length; ++i) {
            JMenuItem menuItem;
            try {
                URL iconURL = this.beans[i].getClass().getResource("images/" + this.beans[i].getName() + "Color16.gif");
                ImageIcon icon = new ImageIcon(iconURL);
                menuItem = new JMenuItem(this.beans[i].getName(), icon);
            }
            catch (Exception e) {
                System.out.println("JCalendarDemo.createMenuBar(): " + e + " for URL: " + "images/" + this.beans[i].getName() + "Color16.gif");
                menuItem = new JMenuItem(this.beans[i].getName());
            }
            componentsMenu.add(menuItem);
            JComponent bean = this.beans[i];
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JCalendarDemo.this.installBean(bean);
                }
            };
            menuItem.addActionListener(actionListener);
        }
        UIManager.LookAndFeelInfo[] lnfs = UIManager.getInstalledLookAndFeels();
        ButtonGroup lnfGroup = new ButtonGroup();
        JMenu lnfMenu = new JMenu("Look&Feel");
        lnfMenu.setMnemonic('L');
        menuBar.add(lnfMenu);
        for (int i = 0; i < lnfs.length; ++i) {
            if (lnfs[i].getName().equals("CDE/Motif")) continue;
            JRadioButtonMenuItem rbmi = new JRadioButtonMenuItem(lnfs[i].getName());
            lnfMenu.add(rbmi);
            rbmi.setSelected(UIManager.getLookAndFeel().getName().equals(lnfs[i].getName()));
            rbmi.putClientProperty("lnf name", lnfs[i]);
            rbmi.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent ie) {
                    JRadioButtonMenuItem rbmi2 = (JRadioButtonMenuItem)ie.getSource();
                    if (rbmi2.isSelected()) {
                        UIManager.LookAndFeelInfo info = (UIManager.LookAndFeelInfo)rbmi2.getClientProperty("lnf name");
                        try {
                            menuBar.putClientProperty("jgoodies.headerStyle", "Both");
                            UIManager.setLookAndFeel(info.getClassName());
                            SwingUtilities.updateComponentTreeUI(JCalendarDemo.this);
                            int i = 0;
                            while (i < JCalendarDemo.this.beans.length) {
                                SwingUtilities.updateComponentTreeUI(JCalendarDemo.this.beans[i]);
                                ++i;
                            }
                            BasicSplitPaneDivider divider = ((BasicSplitPaneUI)JCalendarDemo.this.splitPane.getUI()).getDivider();
                            if (divider != null) {
                                divider.setBorder(null);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            System.err.println("Unable to set UI " + e.getMessage());
                        }
                    }
                }
            });
            lnfGroup.add(rbmi);
        }
        JMenu helpMenu = new JMenu("Help");
        helpMenu.setMnemonic('H');
        JMenuItem aboutItem = helpMenu.add(new AboutAction(this));
        aboutItem.setMnemonic('A');
        aboutItem.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        menuBar.add(helpMenu);
        return menuBar;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (this.calendarPanel == null || evt.getPropertyName().equals("calendar")) {
            // empty if block
        }
    }

    public static void main(String[] s) {
        JFrame frame = new JFrame("Laporan Transaksi");
        JCalendarDemo demo = new JCalendarDemo();
        demo.init();
        frame.getContentPane().add(demo);
        frame.pack();
        frame.setBounds(200, 200, (int)frame.getPreferredSize().getWidth() + 40, (int)frame.getPreferredSize().getHeight() + 250);
        frame.setVisible(true);
    }

    private void installBean(JComponent bean) {
        try {
            this.componentPanel.removeAll();
            BeanInfo beanInfo = Introspector.getBeanInfo(bean.getClass(), bean.getClass().getSuperclass());
            PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
            this.propertyPanel.removeAll();
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 1;
            this.propertyPanel.setLayout(gridbag);
            int count = 0;
            String[] types = new String[]{"class java.util.Locale", "boolean", "int", "class java.awt.Color", "class java.util.Date", "class java.lang.String"};
            for (int t = 0; t < types.length; ++t) {
                for (int i = 0; i < propertyDescriptors.length; ++i) {
                    ActionListener actionListener;
                    if (propertyDescriptors[i].getWriteMethod() == null) continue;
                    String type2 = propertyDescriptors[i].getPropertyType().toString();
                    PropertyDescriptor propertyDescriptor = propertyDescriptors[i];
                    JComponent currentBean = bean;
                    Method readMethod = propertyDescriptor.getReadMethod();
                    Method writeMethod = propertyDescriptor.getWriteMethod();
                    if (!type2.equals(types[t]) || (readMethod == null || writeMethod == null) && !"class java.util.Locale".equals(type2)) continue;
                    if ("boolean".equals(type2)) {
                        boolean isSelected = false;
                        try {
                            Boolean booleanObj = (Boolean)readMethod.invoke((Object)bean, (Object[])null);
                            isSelected = booleanObj;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        JCheckBox checkBox = new JCheckBox("", isSelected);
                        checkBox.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent event) {
                                try {
                                    if (checkBox.isSelected()) {
                                        writeMethod.invoke((Object)currentBean, new Boolean(true));
                                    } else {
                                        writeMethod.invoke((Object)currentBean, new Boolean(false));
                                    }
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        });
                        this.addProperty(propertyDescriptors[i], checkBox, gridbag);
                        ++count;
                        continue;
                    }
                    if ("int".equals(type2)) {
                        JSpinField spinField = new JSpinField();
                        spinField.addPropertyChangeListener(new PropertyChangeListener(){

                            @Override
                            public void propertyChange(PropertyChangeEvent evt) {
                                try {
                                    if (evt.getPropertyName().equals("value")) {
                                        writeMethod.invoke((Object)currentBean, evt.getNewValue());
                                    }
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        });
                        try {
                            Integer integerObj = (Integer)readMethod.invoke((Object)bean, (Object[])null);
                            spinField.setValue(integerObj);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        this.addProperty(propertyDescriptors[i], spinField, gridbag);
                        ++count;
                        continue;
                    }
                    if ("class java.lang.String".equals(type2)) {
                        String string = "";
                        try {
                            string = (String)readMethod.invoke((Object)bean, (Object[])null);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        JTextField textField = new JTextField(string);
                        actionListener = new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                try {
                                    writeMethod.invoke((Object)currentBean, e.getActionCommand());
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        };
                        textField.addActionListener(actionListener);
                        this.addProperty(propertyDescriptors[i], textField, gridbag);
                        ++count;
                        continue;
                    }
                    if ("class java.util.Locale".equals(type2)) {
                        JLocaleChooser localeChooser = new JLocaleChooser(bean);
                        localeChooser.setPreferredSize(new Dimension(200, localeChooser.getPreferredSize().height));
                        this.addProperty(propertyDescriptors[i], localeChooser, gridbag);
                        ++count;
                        continue;
                    }
                    if ("class java.util.Date".equals(type2)) {
                        Date date = null;
                        try {
                            date = (Date)readMethod.invoke((Object)bean, (Object[])null);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        JDateChooser dateChooser = new JDateChooser(date);
                        dateChooser.addPropertyChangeListener(new PropertyChangeListener(){

                            @Override
                            public void propertyChange(PropertyChangeEvent evt) {
                                try {
                                    if (evt.getPropertyName().equals("date")) {
                                        writeMethod.invoke((Object)currentBean, evt.getNewValue());
                                    }
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        });
                        this.addProperty(propertyDescriptors[i], dateChooser, gridbag);
                        ++count;
                        continue;
                    }
                    if (!"class java.awt.Color".equals(type2)) continue;
                    JButton button = new JButton();
                    try {
                        Color colorObj = (Color)readMethod.invoke((Object)bean, (Object[])null);
                        button.setText("...");
                        button.setBackground(colorObj);
                        actionListener = new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                Color newColor = JColorChooser.showDialog(JCalendarDemo.this, "Choose Color", colorObj);
                                button.setBackground(newColor);
                                try {
                                    writeMethod.invoke((Object)currentBean, newColor);
                                }
                                catch (Exception e1) {
                                    e1.printStackTrace();
                                }
                            }
                        };
                        button.addActionListener(actionListener);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    this.addProperty(propertyDescriptors[i], button, gridbag);
                    ++count;
                }
            }
            URL iconURL = bean.getClass().getResource("images/" + bean.getName() + "Color16.gif");
            ImageIcon icon = new ImageIcon(iconURL);
            this.componentTitlePanel.setTitle(bean.getName(), icon);
            bean.invalidate();
            this.propertyPanel.invalidate();
            this.componentPanel.invalidate();
            this.componentPanel.repaint();
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
    }

    private void addProperty(PropertyDescriptor propertyDescriptor, JComponent editor, GridBagLayout grid) {
        String text = propertyDescriptor.getDisplayName();
        String newText = "";
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c >= 'A' && c <= 'Z' || i == 0) {
                if (i == 0) {
                    c = (char)(c - 32);
                }
                newText = newText + " " + c;
                continue;
            }
            newText = newText + c;
        }
        JLabel label = new JLabel(newText + ": ", null, 4);
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 1.0;
        c.fill = 1;
        grid.setConstraints(label, c);
        this.propertyPanel.add(label);
        c.gridwidth = 0;
        grid.setConstraints(editor, c);
        this.propertyPanel.add(editor);
        JPanel blankLine = new JPanel(){
            private static final long serialVersionUID = 4514530330521503732L;

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(10, 2);
            }
        };
        grid.setConstraints(blankLine, c);
        this.propertyPanel.add(blankLine);
    }

    static /* synthetic */ void access$000(JCalendarDemo x0, JComponent x1) {
        x0.installBean(x1);
    }

    static /* synthetic */ JComponent[] access$100(JCalendarDemo x0) {
        return x0.beans;
    }

    static /* synthetic */ JSplitPane access$200(JCalendarDemo x0) {
        return x0.splitPane;
    }

    class AboutAction
    extends AbstractAction {
        private static final long serialVersionUID = -5204865941545323214L;
        private final JCalendarDemo demo;

        AboutAction(JCalendarDemo demo) {
            super("About...");
            this.demo = demo;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            JOptionPane.showMessageDialog(this.demo, "JCalendar Demo\nVersion 1.4\n\nKai Toedter\nkai@toedter.com\nwww.toedter.com", "About...", 1);
        }
    }
}

